import pathlib
import syside

MODEL = "example_model.sysml"
EXAMPLE_DIR = pathlib.Path(__file__).parent
MODEL_FILE_PATH = EXAMPLE_DIR / MODEL


def main() -> None:
    (_, diagnostics) = syside.try_load_model([MODEL_FILE_PATH])

    # Convert diagnostics to use relative paths
    relative_diagnostics = str(diagnostics).replace(str(EXAMPLE_DIR) + "/", "")
    print(relative_diagnostics)


if __name__ == "__main__":
    main()
