import pathlib
import pandas as pd
import syside

EXAMPLE_DIR = pathlib.Path(__file__).parent
REQUIREMENTS_EXCEL = EXAMPLE_DIR / "requirements.xlsx"
REQUIREMENTS_SYSML = EXAMPLE_DIR / "example_model.sysml"


def main() -> None:
    # Load model.
    model, diagnostics = syside.load_model([REQUIREMENTS_SYSML])

    assert not diagnostics.contains_errors(warnings_as_errors=True)

    # Populate the data frame.
    data = []
    for requirement in model.nodes(syside.RequirementDefinition):
        for doc in requirement.documentation.collect():
            print(f"Adding requirement {requirement.declared_name}: {doc.body}")
            data.append(
                {
                    "ID": requirement.declared_name,
                    "REQUIREMENT": doc.body,
                }
            )
    df = pd.DataFrame(data)

    # Save the dataframe to the Excel file.
    df.to_excel(REQUIREMENTS_EXCEL, index=False)


if __name__ == "__main__":
    main()
