import pathlib
import syside


EXAMPLE_DIR = pathlib.Path(__file__).parent
MODEL_FILE_PATH = EXAMPLE_DIR / "example_model.sysml"


def main() -> None:
    (model, diagnostics) = syside.try_load_model([MODEL_FILE_PATH])

    # Only errors cause an exception. Syside may also report warnings and
    # informational messages, but not for this example.
    assert not diagnostics.contains_errors(warnings_as_errors=True)

    # Export the model to JSON
    assert len(model.user_docs) == 1

    with model.user_docs[0].lock() as locked:
        print(
            syside.json.dumps(
                locked.root_node, syside.SerializationOptions.minimal()
            )
        )


if __name__ == "__main__":
    main()
