import pathlib
import syside
import syside.helpers

EXAMPLE_DIR = pathlib.Path(__file__).parent
MODEL_FILE_PATH = EXAMPLE_DIR / "example_model.sysml"


def main() -> None:
    # Load the model. Model can also be loaded by giving its path as a string
    # like syside.load_model("example_model.sysml")
    # However, we recommend using this approach to ensure that the model is
    # found even when the script is run from a different directory.
    (model, diagnostics) = syside.load_model(paths=[MODEL_FILE_PATH])

    # Only errors cause an exception. Syside may also report warnings and
    # informational messages, but not for this example.
    assert not diagnostics.contains_errors(warnings_as_errors=True)

    for element in model.nodes(syside.Documentation):
        assert (
            element.owner is not None
            and element.owner.qualified_name is not None
        ), (
            "In this example, all documentation elements are owned by elements \
        with names."
        )

        # Obtain qualified name
        about = str(element.owner.qualified_name)

        # Print out to the output
        if element.name:
            print(
                f"There is a documentation element called {element.name}, "
                f"which is about {about}, and it says: {element.body}"
            )
        else:
            print(
                f"There is an unnamed documentation element about {about}, "
                f"and it says: {element.body}"
            )


if __name__ == "__main__":
    main()
