---

project_title: "Algorithmic Trading System"
document_title: "Software Requirements Specification"
author: "Sensmetry"
project_reference: "DEMO-2025-001"
document_version: "1.1"
document_version_description: "Non-functional SysML changes."
company_website: "www.example.com"
company_email: "info@example.com"
company_phone: "XXX XXX XXXX"

---
# Software Requirements Specification

{{ title() }}

{{ page_break() }}

## Reference Documents

{{
    list_items(
        data=get_children_with_attributes(
            root_package="'Algorithmic Trading System Design'::Sources",
            metatype="ItemUsage",
            ignore_abstract_metatypes=True,
            attributes={
                "ID": "ElementName",
                "title": "AttributeUsage",
                "url": "AttributeUsage"
            }
        ),
        format="- **[{0}]({2})** - {1}"
    )
}}

## Revision history

{{ revision_history() }}

{{ page_break() }}

## Changes since last version

{{ changelog() }}

{{ page_break() }}

## Table of Contents

{{ toc() }}

{{ page_break() }}

## Introduction

### Purpose

This document serves as the Software Requirements Specification (SRS) for the
Algorithmic Trading System. It outlines the comprehensive set of requirements
that must be met by the system to ensure successful development, deployment, and
operation in live trading environments.

This SRS contains requirements concerning the system's functionalities,
performance, interfaces, and quality attributes from the stakeholder, trader,
risk manager, compliance officer, and the development team's perspectives.

### Scope

{{
    text(data=get_docs(root_package="'Algorithmic Trading Requirements'", doc_name="Scope"),
    format="{1}",
    rows=["0"])
}}

### Requirement Types

The following requirement type prefixes are used throughout this specification:

{{
    generic_table(
        columns=["Prefix", "Name", "Description"],
        rows = get_children_with_attributes(
            root_package="'Algorithmic Trading Definitions'::'Requirement Definitions'",
            metatype="RequirementDefinition",
            ignore_abstract_metatypes=True,
            attributes={
                "Prefix": "AttributeUsage",
                "Name": "ElementName",
                "": "Documentation",
            },
        ),
        flipRowsAndCols=False,
        widths=["20%", "25%", "55%"]
    )
}}

{{ page_break() }}

## Requirements

{{
    repeat_for_each_item(
        data_source=get_children_with_attributes(
            root_package="Algorithmic Trading Requirements",
            metatype="RequirementUsage",
            ignore_abstract_metatypes=True,
            attributes={
                "Name": "ElementName",
                "Description": "Documentation",
                "SuccessCriteria": "Documentation",
                "Justification": "Documentation",
                "Parents": "Req_Parents",
                "Derivations": "Req_Derivations",
                "Implemented" : "Req_Implemented",
                "verifyRequirement" : "Req_Verified",
                "Graph" : "Req_DependencyGraph",
                "Package" : "OwningNamespace",
                "Status" : "AttributeUsage"
            },
        ),
        sections=[
            {"type" : "h3", "value" : 'unique_headers_from_qualified_name(row[9])'},
            {"type" : "h4", "value" : "row[0]"},
            {"type" : "h5", "value" : "Requirement details"},
            {"type" : "table", "value" : 'generic_table(
                columns=["Status", "Identifier", "Description",
                "Success criteria", "Justification", "Parent requirements",
                "Derived requirements", "Dependency graph"],
                rows=[row[10:11] + row[0:6] + row[8:9]],
                flipRowsAndCols=True,
                widths=["25%", "75%"],
                css_class="table-2d",
                col_alignment=["right", "left"]
            )'},
            {"type" : "h5", "value" : "Verification details"},
            {"type" : "table", "value" : 'generic_table(
                columns=["Implemented by", "Validated by"],
                rows=[row[6:8]],
                flipRowsAndCols=True,
                widths=["25%", "75%"],
                css_class="table-2d",
                col_alignment=["right", "left"]
            )'},
        ],
        page_break_between_rows=True
    )
}}

## Traceability Matrix

The traceability matrix below shows which requirements are implemented by which
system modules.

{{
    headless_table(traceability_matrix(
        row_package="Algorithmic Trading Requirements",
        row_metatype="RequirementUsage",
        col_package="'Algorithmic Trading System Design'::'System Instances'",
        col_metatype="PartUsage"),
        css_class="matrix-table",
        col_alignment=["right"]
    )
}}
